define([
    'Layout',
    'modules/page/app-options-menu/app-options-menu-view',
],
function(Layout, AppOptionsMenu) {
    'use strict';
    describe('App Options Menu View', function() {
        var view;
        var $view;
        var layout;
        var header;


        beforeEach(function() {
            layout = new Layout();
            layout.render();
            header = layout.getRegion('header');
            $(header.el).append('<button type="button" id="menu-btn"></button>');
            view = new AppOptionsMenu();

            layout.showChildView('menu', view);
            $view = view.$el;
        });

        it('has a link to Appointments/Requests', function() {
            expect($view.find('#appointments-btn').length).toEqual(1);
            expect($view.find('#appointments-btn').attr('href')).toEqual('#appointments');
            expect($view.find('#appointments-btn').text()).toEqual('Appointments/Requests');
        });

    });
});
